/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.commons.moderation.api;

/**
 * Pojo for keeping a flag reason (text) with its creator (user).
 * @author mnew
 */
public class FlagReason {

    /** The reason content was flagged. */
    private final String reasonText;

    /** The user who created the flag reason. */
    private String user = "";

    /**
     * Create the flag reason. This requires the reason text.
     * @param flagReasonText Free text indicating the reason for flagging.
     */
    public FlagReason(final String flagReasonText) {
        reasonText = flagReasonText;
    }

    /**
     * Set the user who created the flag reason.
     * @param flagUser The display name of the user who added this flag reason.
     */
    public void setUser(final String flagUser) {
        user = flagUser;
    }

    /** @return the flag reason (text). */
    public String getReasonText() {
        return reasonText;
    }

    /** @return the user who created the flag reason. */
    public String getUser() {
        return user;
    }
}
