/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.commons.moderation.api;

import java.util.Arrays;
import java.util.List;

import org.apache.sling.api.resource.Resource;

import com.adobe.cq.social.commons.events.CommentEvent.CommentActions;
import com.adobe.cq.social.scf.Operation;
import com.adobe.cq.social.scf.OperationExtension;
import com.adobe.cq.social.scf.core.SocialEvent;
import com.adobe.granite.activitystreams.Verbs;

/**
 * Hook operation to enable clients register callback during an execution of an operation.
 */
public interface ModerationOperationExtension extends OperationExtension<Resource> {
    public static final String MODERATION_TOPIC = "moderation";

    /**
     * Operation types.
     */
    public enum ModerationOperation implements Operation, SocialEvent.SocialActions {
        /** Deny operation. */
        DENY,
        /** Flag operation. */
        FLAG,
        /** Unflag operation. */
        UNFLAG,
        /** Allow operation. */
        ALLOW,
        /** Close operation. */
        CLOSE,
        /** Reopen (reverse of Close operation). */
        REOPEN,
        /** Delete operation. */
        DELETE;

        @Override
        public String getVerb() {
            switch (this) {
                case DENY:
                    return Verbs.DENY;
                case FLAG:
                    return Verbs.FLAG_AS_INAPPROPRIATE;
                case UNFLAG:
                    return "unflag-as-inappropriate";
                case ALLOW:
                    return Verbs.ACCEPT;
                case CLOSE:
                    return Verbs.CLOSE;
                case REOPEN:
                    return Verbs.OPEN;
                case DELETE:
                    return Verbs.DELETE;
                default:
                    return Verbs.POST;
            }
        }

    };

    /**
     * Get the list of operations that this operation extension is interested in.
     * @return a list of {@link ModerationOperation}
     */
    @Override
    List<ModerationOperation> getOperationsToHookInto();
}
