/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.commons.moderation.events;

import java.util.Map;

import org.osgi.service.event.Event;

import com.adobe.cq.social.commons.moderation.api.ModerationOperationExtension;
import com.adobe.cq.social.scf.core.SocialEvent;
import com.adobe.granite.activitystreams.ObjectTypes;

/**
 * An Event to be sent when a moderation action occurs.
 */

public class ModerationEvent extends SocialEvent<ModerationOperationExtension.ModerationOperation> {

    private static final long serialVersionUID = -7883550559003730544L;

    /**
     * Strings for the topic of this event.
     */
    public static final String TOPIC_SUFFIX = "moderation";
    public static final String TOPIC = SocialEvent.SOCIAL_EVENT_TOPIC_PREFIX + TOPIC_SUFFIX;

    /**
     * Constructors
     */
    public ModerationEvent(final String path, final String userId,
        final ModerationOperationExtension.ModerationOperation action, final Map<String, Object> additionalData) {
        super(TOPIC_SUFFIX, path, userId, action, new BaseEventObject(path, ObjectTypes.EVENT), null, additionalData);
    }

    private ModerationEvent(final Event event) {
        super(event);
    }

    /**
     * Retrieves the ModerationEvent from the given generic {@link Event}.
     * @param event The event.
     * @return The ModerationEvent or <code>null</code> if the given event is not a ModerationEvent.
     */
    public static ModerationEvent fromEvent(final Event event) {

        if (!event.getTopic().equals(TOPIC)) {
            return null;
        }

        return new ModerationEvent(event);
    }

    @Override
    public boolean equals(final Object that) {
        if (that instanceof ModerationEvent) {
            final ModerationEvent obj = (ModerationEvent) that;
            return this.getUserId().equals(obj.getUserId()) && this.getPath().equals(obj.getPath())
                    && this.getAction().equals(obj.getAction());
        }
        return false;
    }
}
