/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.commons.tagcloud.api;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;

import com.adobe.cq.social.commons.tagcloud.impl.TagCloudImpl;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.core.AbstractSocialComponentFactory;

@Component(label = "AEM Communities TagCLoud SocialComponent Factory")
@Service
public class TagCloudCollectionSocialComponentFactory extends AbstractSocialComponentFactory implements
    SocialComponentFactory {

    @Override
    public SocialComponent getSocialComponent(final Resource resource) {
        return new TagCloudImpl(resource, getClientUtilities(resource.getResourceResolver()));
    }

    @Override
    public SocialComponent getSocialComponent(final Resource resource, final SlingHttpServletRequest request) {
        return new TagCloudImpl(resource, getClientUtilities(request));
    }

    @Override
    public SocialComponent getSocialComponent(final Resource resource, final ClientUtilities clientUtilities,
        final QueryRequestInfo queryRequestInfo) {
        return new TagCloudImpl(resource, null);
    }

    @Override
    public String getSupportedResourceType() {
        return TagCloud.RESOURCE_TYPE;
    }
}
