/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.commons.tagging;

import javax.jcr.Session;

import org.apache.sling.api.resource.LoginException;

/**
 * Factory service that provides access to an instance of the implementation of SocialTagManager.
 */
public interface SocialTagManagerFactory {

    /**
     * Returns an implementation of {@link SocialTagManager}.
     * @param session current user session to use
     * @return implementation of {@link SocialTagManager}
     * @throws LoginException when the session is invalid
     */
    SocialTagManager getSocialTagManager(Session session) throws LoginException;

}
