/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.community.api;

/**
 * Define various paths that are used by community multi-tenants and sites.
 */
public class CommunityConstants {
    private CommunityConstants() {
    }

    /** The Constant FORWARDSLASH_CHAR. */
    public static final char FORWARDSLASH_CHAR = '/';

    /** The Constant DASH_CHAR. */
    public static final char DASH_CHAR = '-';

    /**
     * Root location
     */
    /** The Constant CONTENT_ROOT_PATH. */
    public static final String CONTENT_ROOT_PATH = "/content";
    /** Var root location */
    public static final String VAR_ROOT_PATH = "/var";
    /** The Constant ETC_ROOT_PATH. */
    public static final String ETC_ROOT_PATH = "/etc";

    public static final String TENANTS = "tenants";

    /** The Constant TENANT_PREFIX. */
    public static final String TENANT_PREFIX = "tenant-";

    /** The Constant COMMUNITY. */
    public static final String COMMUNITY = "community";

    public static final String SITES = "sites";

    public static final String COMMUNITY_SITE_ROOT_PATH = CONTENT_ROOT_PATH + FORWARDSLASH_CHAR + SITES;
    /** The Constant TENANTS_CONTENT_PATH. */
    public static final String TENANTS_CONTENT_ROOT_PATH = COMMUNITY_SITE_ROOT_PATH + "/tenants";

    /** Community etc root path */
    public static final String COMMUNITY_ETC_ROOT_PATH = ETC_ROOT_PATH + FORWARDSLASH_CHAR + COMMUNITY;
    /** tenant etc root path TODO: we don't need etc root path anymore */
    public static final String TENANTS_ETC_ROOT_PATH = COMMUNITY_ETC_ROOT_PATH + FORWARDSLASH_CHAR + TENANTS;
    /** Site deployment tmp path */
    public static final String PAYLOAD = "payload";
    public static final String COMMUNITY_TMP_ROOT_PATH = VAR_ROOT_PATH + FORWARDSLASH_CHAR + COMMUNITY;
    public static final String TENANTS_TMP_ROOT_PATH = VAR_ROOT_PATH + FORWARDSLASH_CHAR + TENANTS;

    /** The Constant TENANTS_SITE_THEMES. */
    public static final String SITE_THEMES = "sitethemes";

    /** The Constant TENANTS_CONFIGURATION_RELATIVE_PATH. */
    public static final String TENANTS_CONFIGURATION_RELATIVE_PATH = "/configuration/components";
    // Community template path
    public static final String COMMUNITY_TEMPLATE_PATH = "/content/communities/templates";

    /** The constant ETC_TEMPLATES_PATH */
    public static final String TEMPLATES = "templates";

    public static final String ETC_TEMPLATES_PATH = COMMUNITY_ETC_ROOT_PATH + FORWARDSLASH_CHAR + TEMPLATES;

    /** SiteThemes path */
    public static final String ETC_DESIGN = "/etc/designs";

    /** The Constant SITES_ROOT_NAME. */
    public static final String SITES_ROOT_NAME = "sites";
    public static final String COMMUNITY_GROUP_ROOT_NAME = "groups";

    // Activity stream path
    public static final String ACTIVITY_STREAM_NODE_NAME = "activitystreams";

    public static String TENANT_ADMINISTRATORS_GROUP = "administrators";
    public static String TENANT_MODERATORS_GROUP = "moderators";
    public static String TENANT_GROUPADMIN_GROUP = "groupadministrators";
    public static String TENANT_SITEMEMBER_GROUP = "members";
    public static String TENANT_SITE_CONTENT_MANAGER_GROUP = "sitecontentmanager";
    public static String TENANT_USERS_GROUP = "members";
    public static String SOCIAL_AUTHOR_GROUP = "socialauthor";
    /** The Constant CONFIG_NODE_NAME. */
    public static final String CONFIG_NODE_NAME = "configuration";

    public static String TENANT_SITE_ENABLEMENT_MANAGERS_GROUP = "siteenablementmanagers";

    /** The custom subpath. */
    public static String CUSTOM_SUBPATH = "/custom";

    /** The reference subpath. */
    public static String REFERENCE_SUBPATH = "/reference";

}
