/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.community.api;

import java.util.List;

import javax.jcr.RepositoryException;

import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.tenant.Tenant;

import aQute.bnd.annotation.ProviderType;

import com.adobe.cq.social.srp.config.SocialResourceConfiguration;

@ProviderType
public interface CommunityContext {
    /**
     * Get {link Tenant}
     */
    Tenant getTenant();

    /**
     * Get the tenant id
     * @return the tenant id, or null if the context does not belong to a tenant.
     */
    String getTenantId();

    /**
     * Return the site id of this context.
     * @return the site id, or null if the context does not belong to a site.
     */
    String getSiteId();

    /**
     * Return the community group id of this context.
     * @return the group id, or null if the context does not belong to a group.
     */
    String getCommunityGroupId();

    /**
     * Get the content root path for the site in this context.
     * @return
     */
    String getContentRootPath();

    /**
     * Get the configuration path
     * @return /content/social/tenants/<tenantid>/components configuration path.
     */
    String getTenantConfigPath();

    /**
     * Get the location where the site payload is created and replicated
     */
    String getSitePayloadPath();

    /**
     * This method returns the path of the root page path of the site. One of its children node is the configuration
     * node, which has the {@link CommunitySiteConstants.RESOURCE_TYPE} type.
     * @return
     */
    String getSitePagePath();

    /**
     * Get the design root path
     * @return
     */
    String getDesignRootPath();

    String getSiteThemePath();

    /**
     * Get the site path
     */
    String getSitePath();

    /**
     * Get the community group path
     */
    String getCommunityGroupPath();

    /**
     * Get the site banner path for the specified siteId
     * @return
     */
    String getSiteBannerPath();

    /**
     * Check if the multitenant deployment is supported.
     * @return
     */
    boolean isMultiTenantSupported();

    /**
     * Get the ugc root path.
     * @return the ugc root path based on the tenant
     */
    String getUgcPath();

    /**
     * Get the ugc site path.
     * @return the ugc path or null if the context does not belong to a site
     */
    String getUgcSitePath();

    /**
     * Get activity stream root path
     * @return the activitystream root path, or null if this context does not belong to a site
     */
    String getActivityStreamRootPath();

    /**
     * Get the tenant user group name for the specified group
     * @param groupName
     * @return
     * @see getTenantSiteGroupPath(String, String, UserGroup)
     */
    public String getTenantUserGroupName(final String groupName);

    public String getSiteUserGroupName(final CommunityUserGroup userGroup);

    /**
     * Get the fully qualified group name based on this context
     * @param groupName
     * @return
     * @see getTenantSiteGroupPath(String, String, UserGroup)
     */
    public String getFullyQualifiedGroupName(final String groupName);

    /**
     * Get the user group root path of this context.
     * @param tenantId
     * @return
     */
    String getUserGroupRootPath();

    /**
     * Get the user root path of this context.
     */
    String getUserRootPath();

    /**
     * Get the user group path of a tenant. This is applicable to Admin and User groups
     * @param tenantId
     * @return
     */
    public String getUserGroupPath(final String userGroupName);

    /**
     * Check if the specified user id belong to the community administrator group.
     * @param um
     * @param userId
     * @return
     * @throws RepositoryException
     * @see checkIfUserIsGroupAdmin to verify if the specified user is a group administrator.
     */
    public boolean checkIfUserIsAdmin(final UserManager um, final String userId) throws RepositoryException;

    /**
     * Check if the specified user id belong to the group admin or not.
     * @param um
     * @param userId
     * @return
     * @throws RepositoryException
     */
    public boolean checkIfUserIsGroupAdmin(final UserManager um, final String userId) throws RepositoryException;

    /**
     * Check if the specified user id is an administrator base on this context. If the context has a group, it checks
     * if the user is a group administrator, otherwise, it checks if the user is a community administrator.
     * @param um
     * @param userId
     * @return
     * @throws RepositoryException
     */
    public boolean isUserAdmin(final UserManager um, final String userId) throws RepositoryException;

    /**
     * Get the storage configuration path.
     * @return the storage configuration path.
     */
    String getStorageConfigurationPath();

    /**
     * Return the social configuration associated with the tenant.
     * @return the configuration. If in a tenant, the tenant configuration, otherwise the site (default)
     */
    SocialResourceConfiguration getStorageConfig();

    /**
     * Check if the specified user id belongs to the moderator group
     * @param um
     * @param userId
     * @return
     * @throws RepositoryException
     */
    boolean checkIfUserIsModerator(final UserManager um, final String userId) throws RepositoryException;

    String getTenantGroupRootPath();

    String getTenantUserRootPath();

    String getCommunityGroupRootPath();

    String getCommunityUserRootPath();

    /**
     * Get the site's resources path.
     */
    String getSiteResourcesPath();

    /**
     * Get the site's content paths.
     */
    List<String> getSiteContentPaths();

    /**
     * Get the current site's root path.
     * @return site root path
     */
    String getSiteRootPath();

    /**
     * Get the site root path of the current tenant's site with the given siteId.
     * @param siteId given siteId
     * @return root path of the site with the given siteId
     */
    String getSiteRootPath(final String siteId);

    /**
     * Get the current site name if not empty, else return siteId.
     * @return site name
     */
    String getSiteName();

}
