/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 *************************************************************************/
package com.adobe.cq.social.enablement.client.api;

import java.util.Map;

import com.adobe.cq.social.scf.PageInfo;
import com.adobe.cq.social.scf.SocialCollectionComponent;

/**
 * {@code SocialCollectionComponent} representing a catalog of Enablement resources.
 */
public interface CatalogSocialComponent extends SocialCollectionComponent {
    /** Resource type of component. */
    String RESOURCE_TYPE = "social/enablement/components/hbs/catalog";

    /**
     * Gets information about the pages for this collection. This can be used by the page block helper to easily
     * render various pagination UIs.
     * @return information about the pagination system
     */
    PageInfo getPageInfo();

    /**
     * Returns a map of id/display-name pairs of all catalog tags, only if 'tag' filter is not specified in the
     * requestInfo (or if tag filter is 'all-tags'). Otherwise, it will return an empty map.
     * @return Map of of tag id/display-name name/value pairs
     */
    Map<String, String> getAllCatalogTags();
}
