/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 *************************************************************************/
package com.adobe.cq.social.enablement.client.api;

import java.util.List;

import com.adobe.cq.social.enablement.model.api.EnablementContentComponent;
import com.adobe.cq.social.enablement.model.api.PrerequisiteLearningPath;
import com.adobe.cq.social.scf.PageInfo;
import com.adobe.cq.social.scf.SocialCollectionComponent;

/**
 * Enablement Learning path social component.
 */
public interface EnablementLearningPathSocialComponent extends EnablementContentComponent, SocialCollectionComponent {
    /** Resource type of component. */
    String RESOURCE_TYPE = "social/enablement/components/hbs/learningpath";

    /**
     * Gets information about the pages for this collection. This can be used by the page block helper to easily
     * render various pagination UIs.
     * @return information about the pagination system
     */
    PageInfo getPageInfo();

    /**
     * @return the due date of the Resource
     */
    String getDueDate();

    /**
     * @return the friendly due date of the Resource
     */
    String getFriendlyDueDate();

    /**
     * @return whether enforce order is enabled for a learning path
     */
    boolean isEnforcedOrderEnabled();

    /**
     * @return get a list of rules indicating whether a learning path item should be enabled
     */
    List<Boolean> getEnforcedOrderedResourceRule();

    /**
     * @return the prerequisite of learning path
     */
    public List<PrerequisiteLearningPath> getPrerequisites();
}