/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 *************************************************************************/
package com.adobe.cq.social.enablement.client.api;

import java.util.List;
import java.util.Map;

import javax.jcr.RepositoryException;

import com.adobe.cq.social.enablement.model.api.EnablementContentComponent;
import com.adobe.cq.social.enablement.model.api.EnablementContentContact;
import com.adobe.cq.social.scf.SocialComponent;

public interface EnablementResourceSocialComponent extends EnablementContentComponent, SocialComponent {
    String RESOURCE_TYPE = "social/enablement/components/hbs/resource";

    /**
     * @return duration of the Resource
     */
    String getDuration();

    /**
     * @return the size of the Resource
     */
    long getSize();

    /**
     * @return the friendly size of the Resource e.g 10 MB, 20 KB
     */
    String getNormalizedSize();

    /**
     * @return the published date of the Resource
     */
    String getPublishedDate();

    /**
     * @return the friendly due date of the Resource
     */
    String getFriendlyDueDate();

    /**
     * @return the due date of the Resource
     */
    String getDueDate();

    /**
     * @return the image path of the Resource poster
     */
    String getPosterImagePath();

    /**
     * @return the resource asset path (e.g. /content/enablement/data/resources/spiderman/assets/asset/spidey.mp4)
     */
    String getResourceAssetPath();

    /**
     * @return the resource mime type (e.g. video/mp4)
     */
    String getEnablementResourceType();

    /**
     * @return the resource path identifier (e.g. /content/enablement/data/resources/spiderman)
     */
    String getEnablementResourcePath();

    /**
     * @return comments component end-point for this enablement resource (e.g.
     *         /content/enablement/data/resources/spiderman/social1421984027794/jcr:content/comments)
     * @throws RepositoryException -- Throws RepositoryException when not able to find the node
     */
    String getCommentsEndPoint() throws RepositoryException;

    /**
     * @return comments ratings end-point for this enablement resource (e.g.
     *         /content/enablement/data/resources/spiderman/social1421984027794/jcr:content/ratings)
     * @throws RepositoryException -- Throws RepositoryException when not able to find the node
     */
    String getRatingsEndPoint() throws RepositoryException;

    /**
     * @return the marketing cloud org Id required to instantiate video heartbeat
     */
    String getMarketingCloudOrgId();

    /**
     * @return true iff the resource type is image
     */
    boolean isTypeImage();

    /**
     * @return the external url for url resources
     */
    String getExternalUrl();

    /**
     * Gets the authors assigned to the resource.
     * @return authors
     */
    List<EnablementContentContact> getAuthors();

    /**
     * Gets the experts assigned to the resource.
     * @return experts
     */
    List<EnablementContentContact> getExperts();

    /**
     * @return Whether sling resource is an Enablement Resource
     */
    Boolean isEnablementResource();

    /**
     * @return true if the resource can track analytics
     */
    boolean isAnalyticsEnabled();

    /**
     * @return information of learning path that contains current enablement resource
     */
    Map<String, String> getParentLearningPathInfo();

    Boolean isScormResource();

    Map<String, String> getAssetProperties();

    /**
     * @return If resource is completed by a user
     */
    public boolean isResourceCompleted();

    /**
     * Get due status for a resource
     * <ul>
     * <li>"-2": Resource gets completed before due date</li>
     * <li>"-1": Due date is more than 3 days later</li>
     * <li>"1": Due within 3 days</li>
     * <li>"2": Past due</li>
     * </ul>
     * @return String
     */
    public String getDueStatus();
}