/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.enablement.client.api;

import com.adobe.cq.social.enablement.model.api.EnablementSiteConfiguration;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.site.api.CommunitySite;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;

/**
 * {@code SocialComponent} used for accessing Enablement-specific site configuration data (list of Enablement
 * Managers, etc.).
 */
public interface EnablementSite extends SocialComponent {

    /** The resource type. */
    String RESOURCE_TYPE = "social/enablement/components/hbs/enablementsite";

    /**
     * Get the corresponding {@code CommunitySite} parent.
     * @return corresponding Community Site
     */
    @JsonInclude(Include.NON_NULL)
    CommunitySite getSite();

    /**
     * @return Enablement-specific Site configuration
     */
    EnablementSiteConfiguration getConfiguration();
}
