/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 *************************************************************************/
package com.adobe.cq.social.enablement.client.api;

import java.util.List;

import com.adobe.cq.social.scf.SocialComponent;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;

/**
 * {@code SocialComponent} used for retrieving the list of tags associated with the given Enablement resource.
 */
public interface ResourceTagsComponent extends SocialComponent {

    /** The resource type. */
    String RESOURCE_TYPE = "social/enablement/components/hbs/resourcetags";

    /**
     * Gets the list of tags for a given Enablement resource.
     * @return list of tags
     */
    @JsonInclude(Include.NON_NULL)
    List<String> getResourceTags();
}
