/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.enablement.client.reporting.api;

import com.adobe.cq.social.reporting.dv.api.DVBarChart;

public interface EnablementAggregateResourceRatingReport extends DVBarChart {

    /** Resource type of component. */
    String RESOURCE_TYPE = "social/enablement/components/hbs/resourcesreport/aggregateratingsdv";

    /**
     * Average rating of all aggregated resources (out of the highest possible rating) --&gt; e.g. 4/5.
     * @return average
     */
    String getAverage();

    /**
     * Total number of resources that have been rated.
     * @return rated resources count
     */
    Integer getTotalRatedCount();

    /**
     * Total number of resources that have been rated.
     * @return unrated resources count
     */
    Integer getTotalUnratedCount();

    /**
     * Percentage of resources that have been rated.
     * @return percent rated
     */
    String getPercentRated();

    /**
     * Percentage of resources that have not been rated.
     * @return percent unrated
     */
    String getPercentUnrated();
}
