/*******************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *******************************************************************************/
package com.adobe.cq.social.enablement.client.reporting.api;

import com.adobe.cq.social.scf.PageInfo;
import com.adobe.cq.social.scf.SocialCollectionComponent;

public interface EnablementReportGroupEnrollmentList extends SocialCollectionComponent {
    String RESOURCE_TYPE = "social/enablement/components/hbs/reports/groupassignmentreport";

    String GROUP_ID = "groupId";
    String RESOURCE_ID = "resourceId";
    String DRAW = "draw";
    String START = "start";
    String LENGTH = "length";

    /**
     * Gets information about the pages for this collection. This can be used by the page block helper to easily
     * render various pagination UIs.
     * @return information about the pagination system
     */
    PageInfo getPageInfo();

    /**
     * Returns the number of users in the group assigned to the resource.
     * @return assigned users count
     */
    int getAssignedUsersCount();

    /**
     * Returns the number of users in the group having completed the resource.
     * @return completed users count
     */
    int getCompletedUsersCount();

    /**
     * Returns the number of users in the group having passed the resource.
     * @return passed users count
     */
    int getPassedUsersCount();

    /**
     * Returns the number of users in the group having failed the resource.
     * @return failed users count
     */
    int getFailedUsersCount();

    /**
     * Returns the number of users in the group with in-progress status on the resource.
     * @return in-progress users count
     */
    int getInProgressUsersCount();

    /**
     * Returns the number of users in the group with not-started status on the resource.
     * @return not-started users count
     */
    int getNotStartedUsersCount();

    /**
     * Returns the average score for the aggregation of users in the group who have completed the resource.
     * @return average score
     */
    int getAverageScore();
}
