/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.enablement.client.reporting.api;

import com.adobe.cq.social.scf.PageInfo;
import com.adobe.cq.social.scf.SocialCollectionComponent;

/**
 * Enablement resource enrollment report interface.
 */
public interface EnablementResourceEnrollmentReport extends SocialCollectionComponent {

    /** Resource type of component. */
    String RESOURCE_TYPE = "social/enablement/components/hbs/resource/resourcereport/enrollmentreport";

    /**
     * Gets information about the pages for this collection. This can be used by the page block helper to easily
     * render various pagination UIs.
     * @return information about the pagination system
     */
    PageInfo getPageInfo();

    /**
     * Returns whether or not the enrollment is for a Scorm resource.
     * @return true iff the resource is Scorm
     */
    boolean isScormResource();

    /**
     * Returns the Enablement resource type of this resource.
     * @return the Enablement resource type
     */
    String getEnablementResourceAssetType();

    /**
     * Determine if this is a query request.
     * @return true iff this is a query request
     */
    boolean isQueryRequest();
}
