/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 *************************************************************************/
package com.adobe.cq.social.enablement.model.api;

import java.util.List;

import com.adobe.cq.social.scf.SocialComponent;

/**
 * Enablement Content component.
 */
public interface EnablementContentComponent {

    String RESOURCE_HTML_SUFFIX = ".resource.html";
    int DESCRIPTION_TRUNCATION_LIMIT = 500;

    /**
     * @return the Title of the Enablement Content
     */
    String getTitle();

    /**
     * @return the Description of the Enablement Content
     */
    String getDescription();

    /**
     * @return the truncated Description of the Enablement Content
     */
    String getTruncatedDescription();

    /**
     * @return the author of the Enablement Content
     */
    String getAuthorName();

    /**
     * @return the image path of the Enablement Content card
     */
    String getCardImagePath();

    /**
     * @return the page path of the Enablement Content Component
     */
    String getPagePath();

    /**
     * @return Component resource type.
     */
    String getResourceType();

    /**
     * Gets the Enablement Content's primary contacts.
     * @return list of contacts
     */
    List<EnablementContentContact> getContacts();

    /**
     * Sets the parent {@code SocialComponent}.
     * @param socialComponent parent Social Component
     */
    void setParentComponent(final SocialComponent socialComponent);

    String getSitePagePath();
}
