/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 *************************************************************************/
package com.adobe.cq.social.enablement.model.api;

/**
 * Interface for representing contacts for an Enablement Content viz Resource or Learning path.
 */
public interface EnablementContentContact {
    /**
     * @return Name of the Contact
     */
    String getPrincipalName();

    /**
     * @return Authorizable id for the Contact
     */
    String getAuthorizableId();

    /**
     * @return Profile Image of the Contact
     */
    String getProfileImage();

    /**
     * @return Profile path for the contact.
     */
    public String getProfilePath();

    /**
     * @return Email of the Contact.
     */
    String getEmail();
}
