/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.enablement.model.api;

import java.util.List;

import com.adobe.cq.social.user.api.UserProfile;

/**
 * Provides access to Enablement-specific site configuration.
 */
public interface EnablementSiteConfiguration {

    /**
     * Get the site's EnablementManagers.
     * @return Site's Enablement Managers as a list of {@code UserProfile} objects
     */
    List<UserProfile> getEnablementManagers();

    /**
     * Get the marketing cloud org ID for the site (required for video heartbeat).
     * @return MAC org id
     */
    String getMarketingCloudOrgId();
}
