/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 *************************************************************************/
package com.adobe.cq.social.enablement.model.api;

import javax.jcr.RepositoryException;

import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrerequisiteLearningPath {

    private Logger log = LoggerFactory.getLogger(this.getClass());

    public String name;
    public String guuid;
    public String path;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGuuid() {
        return guuid;
    }

    public void setGuuid(String guuid) {
        this.guuid = guuid;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public JSONObject toJsonObject() {
        JSONObject jsonObj = new JSONObject();

        try {
            jsonObj.put("name", getName());
            jsonObj.put("guuId", getGuuid());
            jsonObj.put("path", getPath());

        } catch (final Exception e) {
            log.error("Failed to get the Prerequistie for: " + getName(), e);
        }

        return jsonObj;
    }

}
