/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.enablement.reporting.db.dbwrapper.api;

/*
 * Interface for a Database Access.
 * This interface abstracts database access methods to allow alternate implementations.
 */

import java.sql.Connection;
import java.util.List;

import javax.sql.rowset.CachedRowSet;

public interface DBAccessWrapper {

    public Connection getConnection() throws Exception;

    public void releaseConnection(Connection con);

    public CachedRowSet executeSelect(String sql, List<Object> parameters) throws Exception;

    public CachedRowSet executeSelect(Connection con, String sql, List<Object> parameters) throws Exception;

    public int executeUpdate(String sql, List<Object> parameters) throws Exception;

    public int executeUpdate(Connection con, String sql, List<Object> parameters) throws Exception;

    public int[] executeBatchUpdate(String sql, List<List<Object>> parameters) throws Exception;

    public int[] executeBatchUpdate(Connection con, String sql, List<List<Object>> parameters) throws Exception;

    public void dumpRowSetMetaData(CachedRowSet crs);
}