/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.filelibrary.client.api;

import java.util.Arrays;
import java.util.List;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

import com.adobe.cq.social.commons.CommentSystem;
import com.adobe.cq.social.commons.comments.api.AbstractCommentCollectionConfiguration;
import com.adobe.cq.social.commons.comments.api.CommentCollectionConfiguration;
import com.fasterxml.jackson.annotation.JsonProperty;

public class AbstractFileLibraryConfiguration extends AbstractCommentCollectionConfiguration implements
    FileLibraryConfiguration {
    private boolean isTaggingAllowed;
    private final ValueMap fileLibraryProperties;
    private final Long maxFileSize;
    private final List<String> allowedFileTypes;

    public AbstractFileLibraryConfiguration(final Resource cs) {
        super(cs);
        fileLibraryProperties = cs.adaptTo(ValueMap.class);
        isTaggingAllowed = fileLibraryProperties.get(CommentCollectionConfiguration.PN_ALLOW_TAGGING, false);
        maxFileSize =
            fileLibraryProperties.get(CommentSystem.PROP_FILE_UPLOAD_SIZE,
                CommentSystem.PV_DEFAULT_MAX_ATTACHMENT_SIZE);
        allowedFileTypes = getAttachmentTypes(fileLibraryProperties);

        setAllowsDelete(true);
        setAllowsAttachment(true);
        setAllowsVoting(true);
        setRTEEnabled(true);
    }

    private List<String> getAttachmentTypes(ValueMap fileLibraryProperties) {
        final String allowedFileTypes = fileLibraryProperties.get(CommentSystem.PROP_FILE_UPLOAD_TYPES, String.class);
        if (org.apache.commons.lang.StringUtils.isNotBlank(allowedFileTypes)) {
            return Arrays.asList(allowedFileTypes.split("\\s*,\\s*"));
        } else {
            return null;
        }
    }

    @Override
    @JsonProperty("isTaggingAllowed")
    public boolean isTaggingAllowed() {
        return isTaggingAllowed;
    }

    @Override
    public List<String> getAllowedFileTypes() {
        return allowedFileTypes;
    }

    @Override
    public long getMaxFileSize() {
        return maxFileSize;
    }

    protected ValueMap getFileLibraryProperties() {
        return fileLibraryProperties;
    }

    public boolean useReferrer() {
        return true;
    }
}
