/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.filelibrary.client.api;

import com.adobe.cq.social.commons.comments.api.Comment;
import com.adobe.cq.social.commons.comments.api.CommentCollectionConfiguration;

/**
 * An Asset represents a document or a folder in a FileLibrary. A folder can only contain sub-folders or documents. A
 * document is represented as an attachment of a comment. An asset is represented as a comment, or a reply of a
 * comment, depending on the level of the asset relative to its parents.
 */
public interface Asset<T extends CommentCollectionConfiguration> extends Comment<T> {
    /**
     * JCR properties that maintains the id of the user that effected the last modification of this topic.
     */
    final String LAST_SELF_MOD_BY = "cq:lastSelfModifiedBy";
    final String PN_NAME = "jcr:title";

    /**
     * Get the name of the asset
     */
    public String getName();

    /**
     * Check if this instance is a folder or a document.
     * @return true if this is a folder
     */
    public boolean isFolder();

    /**
     * Get the FileLibrary id for this asset.
     * @return the FileLibrary id.
     */
    String getFileLibraryId();

    /**
     * @return a search engine friendly url to render this post if this post is a topic. if the post is a topic, this
     *         is blank.
     */
    String getFriendlyUrl();

    boolean isFileLibraryClosed();

    String getParentName();

    String getParentFriendlyUrl();

}
