/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.filelibrary.client.api;

import com.adobe.cq.social.scf.SocialComponent;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;

public interface Document extends Asset<FileLibraryConfiguration> {
    /**
     * Get the mime type of this document
     * @return
     */
    @JsonInclude(Include.NON_NULL)
    String getType();

    /**
     * Get the path of the resource of this document
     */
    @JsonInclude(Include.NON_NULL)
    String getPath();

    /**
     * Use getRating instead
     */
    @Override
    @Deprecated
    @JsonIgnore
    public SocialComponent getVotes();

    /**
     * @return the ratings for this document
     */
    public SocialComponent getRating();
}
