/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.filelibrary.client.api;

import com.adobe.cq.social.commons.comments.api.CommentCollection;

/**
 * Specification of a File Library. A File Library is a collection of Folders or Assets.
 */
public interface FileLibrary<P extends Asset, C extends FileLibraryConfiguration> extends CommentCollection<P, C> {
    /** The resource type. */
    String RESOURCE_TYPE_FILELIBRARY = "social/filelibrary/components/hbs/filelibrary";

    /** The resource type folder. */
    String RESOURCE_TYPE_FOLDER = "social/filelibrary/components/hbs/folder";

    /** The resource type asset. */
    String RESOURCE_TYPE_DOCUMENT = "social/filelibrary/components/hbs/document";

    /** The filelibrary postfix. */
    String FILELIBRARY_POSTFIX = "_yrar";

    /**
     * The name parameter
     */
    static final String REQ_PN_NAME = "name";

    /**
     * Property for closed.
     */
    static final String PN_CLOSED = "closed";

    boolean isClosed();

    String getTitle();
}
