/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.filelibrary.client.api;

import java.util.List;

import com.adobe.cq.social.commons.comments.api.CommentCollectionConfiguration;
import com.fasterxml.jackson.annotation.JsonProperty;

public interface FileLibraryConfiguration extends CommentCollectionConfiguration {
    String PV_DEFAULT_RATING_ROOT = "rating";

    /**
     * Checks if is tagging allowed.
     * @return true, if is tagging allowed
     */
    @JsonProperty("isTaggingAllowed")
    boolean isTaggingAllowed();

    long getMaxFileSize();

    List<String> getAllowedFileTypes();

    /**
     * Check if comment within this component use referrer url as its friendly url
     * @return
     */
    boolean useReferrer();
}
