/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.filelibrary.client.api;

import java.io.Serializable;

import com.adobe.cq.social.scf.core.SocialEvent;
import com.adobe.cq.social.scf.core.SocialEvent.EventObject;
import com.adobe.cq.social.scf.core.SocialEvent.SocialActions;
import com.adobe.granite.activitystreams.Verbs;

/**
 * Event fired for changes occurring within a file library.
 */
public final class FileLibraryEvent extends
    SocialEvent<com.adobe.cq.social.filelibrary.client.api.FileLibraryEvent.Type> implements Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 1456940363367133114L;

    /**
     * Property for event type.
     */
    private static final String PROP_EVENT_TYPE = "EventType";

    /**
     * Property for event path.
     */
    private static final String PROP_EVENT_PATH = "EventPath";

    private static final String FILELIBRARY_TOPIC = "fileLibrary";

    /**
     * The topic name for event topic.
     */
    public static final String EVENT_TOPIC = SocialEvent.SOCIAL_EVENT_TOPIC_PREFIX + FILELIBRARY_TOPIC;

    /**
     * The event types supported for the forum and its topics/posts.
     */
    public static enum Type implements SocialActions {

        /**
         * The event fired upon a folder being added.
         */
        FolderAdded,

        /**
         * The event fired upon a post being added.
         */
        FileAdded,

        FolderUpdated, FileUpdated,

        FolderDeleted,

        FileDeleted;
        @Override
        public String getVerb() {
            switch (this) {
                case FolderAdded:
                    return Verbs.POST;
                case FileAdded:
                    return Verbs.ATTACH;
                case FileUpdated:
                case FolderUpdated:
                    return Verbs.UPDATE;
                case FolderDeleted:
                case FileDeleted:
                    return Verbs.DELETE;
                default:
                    throw new IllegalArgumentException();
            }
        }

    }

    public FileLibraryEvent(final String filePath, final String userId, final Type type, final EventObject object,
        final EventObject target) {
        super(FILELIBRARY_TOPIC, filePath, userId, type, object, target, null);
    }

}
