/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.filelibrary.client.api;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.cq.social.ugcbase.core.SocialResourceUtils;
import com.adobe.granite.security.user.UserProperties;
import com.day.cq.commons.jcr.JcrConstants;

public class FileLibraryUtils {

    /** Logger for this class. */
    private static final Logger LOG = LoggerFactory.getLogger(FileLibraryUtils.class);

    /**
     * Find the parent resource for the specified resource. The specified resource can be either a topics, or a post.
     * @param resource the specified resource.
     * @param forceTopic <code>true</code> to return the parent topic
     * @return
     */
    public static Resource getParent(final Resource resource, final boolean forceLibrary) {
        if (resource == null) {
            return null;
        }
        ResourceResolver resolver = resource.getResourceResolver();
        if (SocialResourceUtils.isSocialResource(resource)) {
            Resource parent = resource.getParent();
            if (forceLibrary) {
                while (parent != null) {
                    if (resolver.isResourceType(parent, FileLibrary.RESOURCE_TYPE_FILELIBRARY)) {
                        return parent;
                    }
                    parent = parent.getParent();
                }
            }
            return parent;
        }
        // Relative index base on the comment system, if it is nested, then we need to skip the bucket node.
        Resource parent = resource.getParent();
        while (parent != null) {
            try {
                final Property primaryType = parent.adaptTo(Node.class).getProperty(JcrConstants.JCR_PRIMARYTYPE);

                if (forceLibrary && !resolver.isResourceType(parent, FileLibrary.RESOURCE_TYPE_FILELIBRARY)) {
                    parent = parent.getParent();
                } else {
                    break;
                }
            } catch (final RepositoryException e) {
                LOG.error("Error getParent for " + resource.getPath(), e);
            }
        }
        return parent;

    }

    /**
     * Returns the user properties denoted by the given <code>userId</code>. The user props are looked for using the
     * provided resource resolver, so as to ensure that the user properties are only accessible to users having the
     * necessary access rights on the requested user properties.
     * @param resolver The {@link ResourceResolver}.
     * @param userId The user id for which to retrieve the user properties.
     * @return The {@link UserProperties} or <code>null</code> if not found.
     */
    public static UserProperties getUserProperties(final ResourceResolver resolver, final String userId) {
        final SocialUtils socialUtils = resolver.adaptTo(SocialUtils.class);
        final UserProperties userProperties = socialUtils.getUserProperties(resolver, userId);
        return userProperties;
    }
}
