/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.filelibrary.client.endpoints;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.HttpConstants;

import com.adobe.cq.social.scf.core.servlets.AbstractSessionServlet;

/**
 * This servlet serves all GET requests to .social.json.
 */
@Component(metatype = true, label = "AEM Social Communities FilelibraryDownloadGetServlet",
        description = "This servlet serves the GET request for social components")
@Service(value = javax.servlet.Servlet.class)
@Properties({
    @Property(name = "sling.servlet.resourceTypes", value = {"sling/servlet/default"}, propertyPrivate = true),
    @Property(name = "sling.servlet.methods", value = {HttpConstants.METHOD_GET}, propertyPrivate = true),
    @Property(name = "sling.servlet.selectors", value = {FilelibraryDownloadGetServlet.DOWNLOAD},
            propertyPrivate = false),
    @Property(name = "sling.servlet.extensions", value = {"json"}, propertyPrivate = false)})
public class FilelibraryDownloadGetServlet extends AbstractSessionServlet {
    protected static final String CONTENT_TYPE = "application/json";

    protected static final String ENCODING = "utf-8";

    private static final long serialVersionUID = 351915124629267812L;

    /** Logger for this class. */
    private static final Logger LOG = LoggerFactory.getLogger(FilelibraryDownloadGetServlet.class);

    public static final String DOWNLOAD = "download";

    @Override
    protected final void doPost(final SlingHttpServletRequest request, final SlingHttpServletResponse response)
        throws ServletException, IOException {
        // do nothing - we don't handle post request in this servlet
        this.handleMethodNotImplemented(request, response);
    }

    @Override
    protected final void doGet(final SlingHttpServletRequest request, final SlingHttpServletResponse response)
        throws ServletException, IOException {

        final Resource fileResource = request.getResource();
        InputStream inStream = fileResource.adaptTo(InputStream.class);

        ServletContext context = getServletContext();
        String mimeType = context.getMimeType(fileResource.getPath());

        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }

        response.setContentType(mimeType);

        String headerKey = "Content-Disposition";
        // This may not work on some browser.  See http://greenbytes.de/tech/tc2231/
        String headerValue = String.format("attachment; filename*=UTF-8''%s", URLEncoder.encode(fileResource.getName(), "UTF-8"));
        response.setHeader(headerKey, headerValue);

        OutputStream outStream = response.getOutputStream();

        byte[] buffer = new byte[4096];
        int bytesRead = -1;

        while ((bytesRead = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, bytesRead);
        }

        inStream.close();
        outStream.close();
    }

}
