/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.forum.client.api;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

import com.adobe.cq.social.commons.CommentUtil;
import com.adobe.cq.social.commons.comments.api.AbstractCommentCollection;
import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentListProviderManager;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;

public abstract class AbstractForum<P extends Post, C extends ForumConfiguration> extends
    AbstractCommentCollection<P, C> implements Forum<P, C> {
    private final String title;
    private final boolean isClosed;
    private ForumConfiguration configuration;

    /**
     * Construct a {@link Forum} with the specified root resource.
     * @param resource the root resource
     * @param clientUtils clientUtilites of the resource
     * @param listProviderManager THe List provider manager for the component
     */
    public AbstractForum(final Resource resource, final ClientUtilities clientUtils,
        final CommentSocialComponentListProviderManager listProviderManager) {
        this(resource, clientUtils, QueryRequestInfo.DEFAULT_QUERY_INFO_FACTORY.create(), listProviderManager);
    }

    /**
     * Construct a {@link Forum} with the specified root resource.
     * @param resource the root resource
     * @param clientUtils clientUtilites of the resource
     * @param queryInfo The query request info
     * @param listProviderManager THe List provider manager for the component
     */
    public AbstractForum(final Resource resource, final ClientUtilities clientUtils,
        final QueryRequestInfo queryInfo, final CommentSocialComponentListProviderManager listProviderManager) {
        super(resource, clientUtils, queryInfo, listProviderManager);
        final ResourceResolver resolver = resource.getResourceResolver();
        final PageManager pageManager = resolver.adaptTo(PageManager.class);
        final ValueMap properties = ResourceUtil.getValueMap(resource);
        final SocialUtils socialUtils = clientUtils.getSocialUtils();
        if (socialUtils != null) {
            final Page page = socialUtils.getContainingPage(resource);
            if (page != null) {
                title = page.getTitle();
            } else {
                title = null;
            }
        } else {
            title = null;
        }
        isClosed = properties.get(com.adobe.cq.social.forum.api.Forum.PN_CLOSED, false);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    @JsonProperty("isClosed")
    public boolean isClosed() {
        return isClosed;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean getMayPost() {
        boolean mayPost = super.getMayPost();
        boolean isUserPrivileged =
            CommentUtil.isUserPrivileged(resource, resource.getResourceResolver(), clientUtils.getAuthorizedUserId());
        return mayPost && isUserPrivileged;
    }

    @Override
    @JsonInclude(value = Include.NON_NULL)
    public String getTitle() {
        return title;
    }

    @Override
    protected C createConfiguration(final Resource resource) {
        return (C) new BaseForumConfiguration(resource);
    }
}
