/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.forum.client.api;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.adobe.cq.social.commons.comments.api.AbstractCommentCollectionConfiguration;
import com.adobe.cq.social.commons.comments.api.CommentCollectionConfiguration;
import com.fasterxml.jackson.annotation.JsonProperty;

public class BaseForumConfiguration extends AbstractCommentCollectionConfiguration implements ForumConfiguration {
    String PN_TAG_FILTER = "taggingFilter";
    String PN_TAG_FILTER_LIMIT = "tagFilterLimit";
    private final boolean isTaggingAllowed;
    private final ValueMap forumProperties;
    private final String[] tagFilterVal;
    private final long tagFilterLimitVal;
    private final boolean isUsingPriviligedUsers;
    private static final Logger LOG = LoggerFactory.getLogger(BaseForumConfiguration.class);

    public BaseForumConfiguration(final Resource forumResource) {
        super(forumResource);
        forumProperties = forumResource.adaptTo(ValueMap.class);
        isTaggingAllowed =
            (forumProperties != null) ? forumProperties.get(CommentCollectionConfiguration.PN_ALLOW_TAGGING, false)
                : false;
        tagFilterVal = (forumProperties != null) ? forumProperties.get(PN_TAG_FILTER, String[].class) : new String[0];
        tagFilterLimitVal = (forumProperties != null) ? forumProperties.get(PN_TAG_FILTER_LIMIT, -1) : -1;
        final String[] privilegedUserGroups =
            (forumProperties != null) ? forumProperties.get(CommentCollectionConfiguration.PRIVILEGED_USERS_GROUP,
                String[].class) : new String[0];
        if (privilegedUserGroups != null && privilegedUserGroups.length > 0) {
            isUsingPriviligedUsers = true;
        } else {
            isUsingPriviligedUsers = false;
        }

    }

    @Override
    @JsonProperty("isTaggingAllowed")
    public boolean isTaggingAllowed() {
        return isTaggingAllowed;
    }

    protected ValueMap getForumProperties() {
        return forumProperties;
    }

    @Override
    public String getTagFilterVal() {
        if (tagFilterVal == null || tagFilterVal.length < 1) {
            return null;
        }
        String out = tagFilterVal[0];
        for (int i = 1; i < tagFilterVal.length; i++) {
            out += "," + tagFilterVal[i];
        }
        return out;
    }

    @Override
    public long getTagFilterLimit() {
        return tagFilterLimitVal;
    }

    @Override
    public boolean isBreadcrumbsEnabled() {
        return forumProperties == null ? true : forumProperties.get(ForumConfiguration.PN_SHOW_BREADCRUMBS, true);
    }

    @Override
    public boolean isUsingPrivilegedUsers() {
        return isUsingPriviligedUsers;
    }

}