/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.forum.client.api;

import com.adobe.cq.social.commons.comments.api.CommentCollection;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Specification of a forum. A Forum is a collection of topics.
 */
public interface Forum<P extends Post, C extends ForumConfiguration> extends CommentCollection<P, C> {

    /** The resource type. */
    String RESOURCE_TYPE = "social/forum/components/hbs/forum";

    /** The resource type post. */
    String RESOURCE_TYPE_POST = "social/forum/components/hbs/post";

    /** The resource type topic. */
    String RESOURCE_TYPE_TOPIC = "social/forum/components/hbs/topic";

    /** The topic postfix. */
    String TOPIC_POSTFIX = "_ciot";

    /**
     * The topic parameter
     */
    static final String REQ_PN_SUBJECT = "subject";

    /**
     * Check if this forum is closed.
     * @return <code>true</code> if this forum is closed, otherwise, returns <code>false</code>
     */
    @JsonProperty("isClosed")
    public boolean isClosed();

    /**
     * Get the forum's title.
     * @return the forum title
     */
    public String getTitle();
}
