/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.forum.client.api;

import com.adobe.cq.social.commons.comments.api.CommentCollectionConfiguration;
import com.fasterxml.jackson.annotation.JsonProperty;

public interface ForumConfiguration extends CommentCollectionConfiguration {
    static String PN_SHOW_BREADCRUMBS = "showCrumbs";

    /**
     * Checks if is tagging allowed.
     * @return true, if is tagging allowed
     */
    @JsonProperty("isTaggingAllowed")
    boolean isTaggingAllowed();

    /**
     * The filter value for getting tags.
     * @return a string of the path to filter
     */
    String getTagFilterVal();

    /**
     * The limit value for getting tags.
     * @return a maximum number of tags to display.
     */
    long getTagFilterLimit();

    /**
     * @return true if the forum is configured to show breadcrumbs, false otherwise. defaults to true
     */
    boolean isBreadcrumbsEnabled();

    /**
     * Checks if priviliged users group is set.
     * @return true, if is using priviliged users
     */
    boolean isUsingPrivilegedUsers();
}
