/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.forum.client.api;

import javax.jcr.RepositoryException;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentListProviderManager;
import com.adobe.cq.social.forum.client.impl.PostImpl;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.CollectionPagination;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.core.AbstractSocialComponentFactory;

/**
 * @deprecated this class is not for public use in AEM 6.1. An alternative will be provided in a future featurepack
 */
@Deprecated
@Component
@Service
public class PostSocialComponentFactory extends AbstractSocialComponentFactory implements SocialComponentFactory {

    /** Logger for this class. */
    private static final Logger LOG = LoggerFactory.getLogger(PostSocialComponentFactory.class);

    @Reference
    private CommentSocialComponentListProviderManager listProviderManager;

    @Override
    public SocialComponent getSocialComponent(final Resource resource) {
        return this.getSocialComponent(resource, null);
    }

    @Override
    public SocialComponent getSocialComponent(final Resource resource, final SlingHttpServletRequest request) {
        if (request == null) {
            return this.getSocialComponent(resource, getClientUtilities(resource.getResourceResolver()),
                getQueryRequestInfo(request));
        }
        return this.getSocialComponent(resource, getClientUtilities(request), getQueryRequestInfo(request));
    }

    @Override
    public SocialComponent getSocialComponent(final Resource resource, final ClientUtilities clientUtils,
        final QueryRequestInfo queryInfo) {
        try {
            // final CollectionPagination pagination = queryInfo.getPagination();
            // ForumListCollectionImpl listCollection = new ForumListCollectionImpl(resource,
            // pagination.getOffset(),
            // pagination.getSize(),
            // false, null);
            return new PostImpl(resource, clientUtils, queryInfo, listProviderManager);
        } catch (final RepositoryException e) {
            LOG.error("Failed to create Post instance for {}", resource.getPath(), e);
            return null;
        }
    }

    @Override
    public String getSupportedResourceType() {
        return Forum.RESOURCE_TYPE_POST;
    }

}
