/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.graph;

import javax.annotation.CheckForNull;

import org.apache.sling.api.resource.Resource;

import com.adobe.granite.socialgraph.Relationship;

/**
 * <code>Relationship</code> specifies an edge in the social graph and represents the relationship between two graph
 * nodes (users, groups, topics).
 */
public interface Edge extends Relationship {
    String FOLLOWING_RELATIONSHIP_TYPE = "following";

    String getStartId();

    String getEndId();

    /**
     * Gets the resource that backs this relationship.
     * @return the resource, unless the relationship is virtual then null
     */
    @CheckForNull
    Resource getResource();

}