/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.graph;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

/**
 * <code>SocialGraph</code> encapsulates an abstraction of a directed graph of node. A node in the graph is bound to a
 * user and the edges between the graph are established by relationships. The <code>SocialGraph</code> is bound to a
 * resource resolver and can be adapted from one.
 */
@SuppressFBWarnings("NM_SAME_SIMPLE_NAME_AS_INTERFACE")
public interface SocialGraph extends com.adobe.granite.socialgraph.SocialGraph {

    /**
     * Returns the node for the given id. Note that this method always returns a GraphNode for a valid social object,
     * even if the persistent object for the given id does not exist in the underlying system.
     * @param id the id to retrieve the node for
     * @return the graph node or <code>null</code> of the social object with <code>id</code> does not exist.
     */
    Vertex getVertex(String id);

    /**
     * @return the root path where we store vertices of the graph.
     */
    String getRootPath();

}