/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.graph;

import com.adobe.cq.social.ugc.api.UgcFilter;
import com.adobe.granite.socialgraph.Direction;
import com.adobe.granite.socialgraph.GraphNode;
import com.adobe.granite.socialgraph.Relationship;
import com.adobe.granite.socialgraph.SocialGraphException;

/**
 * A <code>Vertex</code> represents a user or a resource in the social graph. TODO: The original granite GraphNode get
 * vertices APIs do not support pagination. This is a difficult problem to solve. For example, when we retrieve
 * followings activities of a user, we need to retrieve all the followed users to construct the query of the activity
 * stream.
 */
public interface Vertex extends GraphNode {
    /**
     * Creates a relationship to the given node.
     * @param other the other node
     * @param type the type of the relationship
     * @param relType the type of the node (other node) that is being followed
     * @return the relationship
     * @throws IllegalArgumentException if the relationship already exists
     * @throws SocialGraphException if an error during this operation occurs.
     */
    Edge createRelationshipTo(GraphNode other, String type, String relType);

    Iterable<Relationship> getRelationships(Direction dir, UgcFilter filter, String... types);

    /**
     * @param dir direction of relationship
     * @param relType type of the end node to be filtered by
     * @param types relationship type
     * @return relationships that match the criteria
     */
    Iterable<Relationship> getRelationships(String relType, Direction dir, String... types);

    Iterable<Relationship> getRelationships(String relType, Direction dir, UgcFilter filter, String... types);
}