/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.graph.client.api;

import com.adobe.cq.social.graph.Edge;
import com.adobe.cq.social.graph.SocialGraph;
import com.adobe.cq.social.graph.Vertex;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.User;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;

public interface Following extends SocialComponent {
    String RESOURCE_TYPE = "social/socialgraph/components/hbs/following";
    String PROP_USERID = "userId";
    String PROP_FOLLOWEDID = "followedId";

    /**
     * Get the user
     * @return the follower
     */
    User getUser();

    /**
     * Get the followed Id. This could be a CommunityUser or other SocialComponent.
     * @return the followed component
     */
    @JsonInclude(Include.NON_NULL)
    String getFollowedId();

    /**
     * Get the followed Resource Type
     * @return
     */
    String getFollowedResourceType();

    /**
     * Indicate whether the current user can follow the specify following user.
     * @return true if the followed component can be followed.
     */
    boolean getMayFollow();

    /**
     * Check the follow state
     * @return the current following status
     */
    boolean getIsFollowed();

    /**
     * Check if the followed item is a user
     * @return true if the followed user is a user
     */
    boolean getIsFollowedUser();

    /**
     * Get socialGraph of this instance.
     * @return the social graph
     */
    SocialGraph socialGraph();

    /**
     * Get the relationship representing this instance
     * @return the edge of this instance
     */
    Edge edge();

    /**
     * Get the user social graph node
     * @return the vertex of this instance
     */
    Vertex userNode();

    /**
     * Get the followed user graph node
     * @return the followed vertex node
     */
    Vertex followedNode();

}
