/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.graph.client.endpoint;

import org.apache.sling.api.SlingHttpServletRequest;

import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.SocialComponent;

public interface FollowingOperations {
    /**
     * Publish a community site base on the specified {@link SlingHttpServletRequest}
     * @param request the client request
     * @return the published {@link SocialComponent}
     * @throws OperationException if there is an error occurs
     */
    SocialComponent follow(final SlingHttpServletRequest request) throws OperationException;

    /**
     * Un-publish a community site base on the specified {@link SlingHttpServletRequest}
     * @param request the client request
     * @return the unpublished {@link SocialComponent}
     * @throws OperationException if there is an error occurs
     */
    SocialComponent unfollow(final SlingHttpServletRequest request) throws OperationException;

}
