/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.group.api;

/**
 * The <code>GroupConstants</code> defines constant values using by community groups.
 */
public class GroupConstants {

    /**
     * The property name for the administrative group.
     */
    public static final String GROUP_ADMINGROUP = "admingroup";

    /**
     * The property name for the moderator group.
     */
    public static final String GROUP_MODERATORGROUP = "moderatorgroup";

    /**
     * The property name for the member group.
     */
    public static final String GROUP_MEMBERGROUP = "membergroup";

    /**
     * The property name for the group name.
     */
    public static final String GROUP_GROUPNAME_PROPERTY = "groupname";

    /**
     * The user groups root path attribute using by form manager.
     */
    public static final String GROUP_GROUPROOT_PROPERTY = "grouproot";

    /**
     * The suffix of community administrative group name.
     */
    public static final String GROUP_ADMINGROUP_SUFFIX = "-admins";

    /**
     * The suffix of community moderator group name.
     */
    public static final String GROUP_MODERATORGROUP_SUFFIX = "-moderators";

    /**
     * The suffix of community member group name.
     */
    public static final String GROUP_MEMBERGROUP_SUFFIX = "-members";

    /**
     * The community group privacy type is Open.
     */
    public static final String TYPE_OPEN = "Open";

    /**
     * The community group privacy type is Closed.
     */
    public static final String TYPE_CLOSED = "Closed";

    /**
     * The community group privacy type is Secret.
     */
    public static final String TYPE_SECRET = "Secret";

    /**
     * The property name for the user group path using by form.
     */
    public static final String PROPERTY_USERGROUP_PATH = "userGroupPath";

    /**
     * The property name for community group name using by form.
     */
    public static final String PROPERTY_GROUP_NAME = "socialGroupName";

    /**
     * The property name for live-copy title using by form.
     */
    public static final String PROPERTY_LIVECOPY_TITLE = "liveCopyTitle";

    /**
     * The property name for live-copy path using by form.
     */
    public static final String PROPERTY_LIVECOPY_PATH = "liveCopyPath";

    /**
     * The property name for child pages using by form.
     */
    public static final String PROPERTY_CHAPTER_PAGES = "msmChapterPages";

    /**
     * The property name for roll-out configures using by form.
     */
    public static final String PROPERTY_ROLLOUT_CONFIGS = "msmRolloutConfigs";

    /**
     * The property name for user id.
     */
    public static final String PROPERTY_USER_ID = "uid";

    /**
     * The property name for group id.
     */
    public static final String PROPERTY_GROUP_ID = "groupid";

    /**
     * The property name for description.
     */
    public static final String PROPERTY_DESCRIPTION = "jcr:description";

    /**
     * The property name for invite-to-join list using by form.
     */
    public static final String PROPERTY_INVITE_LIST = "inviteList";

    /**
     * The property name for community group privacy type.
     */
    public static final String PROPERTY_TYPE = "type";

    /**
     * The property name for community group image.
     */
    public static final String PROPERTY_IMAGE_NAME = "image";

    /**
     * The default value for community group image path.
     */
    public static final String PROPERTY_IMAGE_PATH = "photos";

    /**
     * The property name for community group form payload.
     */
    public static final String PROPERTY_FORM_PAYLOAD = "formPayload";

    /**
     * The property name for community group form payload.
     */
    public static final String PROPERTY_THEME_PAYLOAD = "themePayload";
}
