/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.group.client.api;

import com.day.cq.commons.jcr.JcrConstants;

/**
 * The Interface CommunityGroupConstants.
 */
public interface CommunityGroupConstants {

    /** The prop community group name. */
    String PROP_COMMUNITY_GROUP_NAME = "urlName";                      // String

    /** The prop community group description. */
    String PROP_COMMUNITY_GROUP_DESCRIPTION = JcrConstants.JCR_DESCRIPTION;      // String

    /** The prop community group title. */
    String PROP_COMMUNITY_GROUP_TITLE = "name";                       // String

    /** The prop community group blueprint id. */
    String PROP_COMMUNITY_GROUP_BLUEPRINT_ID = "blueprint";           // String

    /** The prop community group creator. */
    String PROP_COMMUNITY_GROUP_CREATOR = "owner";

    /** The prop community group invite. */
    String PROP_COMMUNITY_GROUP_INVITE = "invite";                    // String

    /** The prop community group users. */
    String PROP_COMMUNITY_GROUP_USERS = "users";                    // String

    /** The prop community group privacy type. */
    String PROP_COMMUNITY_GROUP_TYPE = "type";                        // String

    /** The prop community group file. */
    String PROP_COMMUNITY_GROUP_FILE = "file";                        // attachment file

    /** The prop community group path. */
    String PROP_COMMUNITY_GROUP_PATH = "path";                        // String

    /** The prop allowed community group templates. */
    String PROP_COMMUNITY_GROUP_ALLOWED_TEMPLATES = "groupTemplates"; // Array

    /** The config node name. */
    String CONFIG_NODE_NAME = "configuration";

    /** The config nodetype. */
    String CONFIG_NODETYPE = "sling:Folder";

    /** The folder nodetype. */
    String FOLDER_NODETYPE = "sling:Folder";

    String ROOT_FOR_CREATE_COMMUNITY_NUGGETS = "/create";
    String ROOT_FOR_PUBLISH_COMMUNITY_NUGGETS = "/publish";

    /** The create community group action type. */
    String ACTION_TYPE_CREATE_COMMUNITY_GROUP = "Create Community Group";
    /** The publish community group action type. */
    String ACTION_TYPE_PUBLISH_COMMUNITY_GROUP = "Publish Community Group";
    /** The publish community site action type. */
    String ACTION_TYPE_PUBLISH_COMMUNITY_SITE = "Publish Community Site";

    /** Path to the default group image */
    String DEFAULT_IMAGE_PATH = "/etc/clientlibs/social/hbs/communitygroups/images/default.png";
}
