/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.group.client.api;

import javax.jcr.Session;

import com.adobe.cq.social.scf.PageInfo;
import com.adobe.cq.social.scf.SocialCollectionComponent;

/**
 * @author vibhatia
 */
public interface CommunityGroupMemberListComponent extends SocialCollectionComponent {
    public static final String RESOURCE_TYPE = "social/group/components/hbs/communitygroupmemberlist";

    String GROUP_ADMIN_PERMISSIONS = Session.ACTION_ADD_NODE + "," + Session.ACTION_READ + ","
            + Session.ACTION_REMOVE + "," + Session.ACTION_SET_PROPERTY;

    /**
     * Check if logged in user can invite group members.
     * @return true if logged in user can invite group members
     */
    boolean isCanInvite();

    /**
     * Gets information about the pages for this collection. This can be used by the page block helper to easily
     * render various pagination UIs.
     * @return information about the pagination system
     */
    PageInfo getPageInfo();
}
