/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.group.client.api;

import javax.jcr.RepositoryException;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;

import com.adobe.cq.social.group.api.GroupException;

/**
 * <code>CommunityGroupService</code> provides a service managing community groups.
 */
public interface CommunityGroupService {

    // static final String REPLICATE_NODE_TYPE = "oak:Unstructured";
    // static final String REPLICATE_NODE_NAME = "created";
    // static final String REPLICATE_PROPERTY_PATH = "path";
    // static final String REPLICATE_PROPERTY_ACTION = "action";

    void setCommunityGroupConfigure(final ResourceResolver resolver, final String groupPath, final ValueMap properties)
        throws RepositoryException;

    /**
     * Create user groups and apply member ACLs for the Community Group.
     * @param resolver resource resolver.
     * @param group community group
     * @param groupsRoot community group root path.
     * @param properties community group properties
     * @throws GroupException - thrown if unable to activate the community.
     * @throws RepositoryException - thrown if unable to activate the community.
     */
    void prepareUserGroups(final ResourceResolver resolver, final Resource group, final String groupsRoot,
        final ValueMap properties) throws GroupException, RepositoryException;

}