/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.group.client.api;

import com.adobe.cq.social.scf.SocialComponent;

public interface CommunityGroupUser extends SocialComponent {

    String RESOURCE_TYPE = "social/group/components/hbs/communitygroupmember";

    /**
     * returns is this user is admin for the group the users are returned
     */
    public Boolean isAdmin();

    /**
     * Check if logged in user can invite group members.
     * @return true if logged in user can invite group members
     */
    boolean isCanInvite();

    /**
     * Get the description of the User.
     */
    String getDescription();

    /**
     * Check if logged in user can promote group members.
     * @return true if logged in user can promote group members
     */
    boolean isCanPromote();
}
