/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.group.client.api;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.adobe.cq.social.badging.api.BadgingService;
import com.adobe.cq.social.group.client.impl.CommunityGroupUserImpl;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.core.AbstractSocialComponentFactory;
import com.adobe.cq.social.scoring.api.ScoringService;
import com.adobe.granite.security.user.UserPropertiesManager;

@Component(label = "AEM Communities CommunityGroupUserSocialComponentFactory")
@Service
public class CommunityGroupUserSocialComponentFactory extends AbstractSocialComponentFactory implements
    SocialComponentFactory {

    @Reference
    private ScoringService scoring;
    @Reference
    private BadgingService badging;
    private static final Logger LOG = LoggerFactory.getLogger(CommunityGroupUserSocialComponentFactory.class);

    @Override
    public SocialComponent getSocialComponent(final Resource resource) {
        return new CommunityGroupUserImpl(resource, getClientUtilities(resource.getResourceResolver()),
            getUserPropertiesManager(resource), scoring, badging);
    }

    @Override
    public SocialComponent getSocialComponent(final Resource resource, final SlingHttpServletRequest request) {
        return new CommunityGroupUserImpl(resource, getClientUtilities(request), getUserPropertiesManager(resource),
            scoring, badging);
    }

    @Override
    public SocialComponent getSocialComponent(final Resource resource, final ClientUtilities clientUtils,
        final QueryRequestInfo requestInfo) {
        return new CommunityGroupUserImpl(resource, clientUtils, getUserPropertiesManager(resource), scoring, badging);
    }

    @Override
    public String getSupportedResourceType() {
        return CommunityGroupUser.RESOURCE_TYPE;
    }

    /**
     * @param resource a resource get the resource resolver from
     * @return an instance of the {@link UserPropertiesManager}
     */
    protected UserPropertiesManager getUserPropertiesManager(final Resource resource) {
        return resource.getResourceResolver().adaptTo(UserPropertiesManager.class);
    }

    /**
     * @return an instance of {@link ScoringService}
     */
    @Deprecated
    protected ScoringService getScoringService() {
        return scoring;
    }

}
