/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.group.client.endpoints;

import java.util.List;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

import com.adobe.cq.social.group.client.api.CommunityGroup;
import com.adobe.cq.social.scf.Operation;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.SocialComponent;

public interface CommunityGroupOperations extends Operation {

    Resource create(final SlingHttpServletRequest request) throws OperationException;

    Resource join(final SlingHttpServletRequest request) throws OperationException;

    Resource leave(final SlingHttpServletRequest request) throws OperationException;

    Resource invite(final SlingHttpServletRequest request) throws OperationException;

    Resource uninvite(final SlingHttpServletRequest request) throws OperationException;

    Resource promoteMember(final SlingHttpServletRequest request) throws OperationException;

    Resource demoteMember(final SlingHttpServletRequest request) throws OperationException;

    boolean approveJoin(final ResourceResolver resolver, final CommunityGroup group) throws OperationException;

    List<Object> getAllowedTemplateForEveryone(String[] paths);

    /**
     * Get the <code>SocialComponent</code> for the specified {@link CommunityGruop} and
     * {@link SlingHttpServletRequest}.
     * @param communityGroup the target community group
     * @param request the client request
     * @return the {@link SocialComponent}
     */
    SocialComponent getCommunityGroupComponentForResource(final Resource communityGroup,
        final SlingHttpServletRequest request);

    SocialComponent getCommunityMemberListComponentForResource(final Resource communityGroup,
        final SlingHttpServletRequest request);
}
