/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.handlebars.api;

import java.util.List;
import java.util.Map;

import org.apache.sling.api.SlingHttpServletRequest;

/**
 * The Interface TemplateContextProvider.
 */
public interface TemplateContextProvider {

    /** The context for all types. */
    String CONTEXT_FOR_ALL_TYPES = "#all";

    /** The root key. */
    String ROOT_KEY = "#root";

    /**
     * Gets the resource types.
     * @return the resource types
     */
    List<String> getResourceTypes();

    /**
     * Gets the context.
     * @param request the request
     * @param contextForResource the resource context that is being added to
     * @return the context
     */
    Map<String, Object> getContext(SlingHttpServletRequest request, Map<String, Object> contextFromResource);

    /**
     * Gets the context key.
     * @return the context key
     */
    String getContextKey();
}
