/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.journal.client.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.adobe.cq.social.commons.events.CommentEvent.CommentActions;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.core.SocialEvent;
import com.adobe.granite.activitystreams.ObjectTypes;
import com.adobe.granite.activitystreams.Verbs;

/**
 * Defines events that are triggered in journals.
 */
public class JournalEvent extends SocialEvent<JournalEvent.JournalActions> {

    private static final long serialVersionUID = 1L;
    /**
     * The event topic suffix for journal events.
     */
    public static final String JOURNAL_TOPIC = "journal";
    protected static final String JOURNAL_PATH = "JOURNAL_PATH";

    /**
     * @param journalEntry - the journal entry page on which the event was triggered.
     * @param userId - the user id of the user who triggered the event.
     * @param action - the journal action that triggered this event.
     */

    public JournalEvent(final JournalEntryComment journalEntry, final String userId,
        final JournalEvent.JournalActions action) {
        super(JOURNAL_TOPIC, journalEntry.getResource().getPath(), userId, action, new BaseEventObject(
            getDisplayName(journalEntry, action), journalEntry.getResource().getPath(), journalEntry.isTopic()
                ? ObjectTypes.COLLECTION : ObjectTypes.COMMENT), new BaseEventObject(getDisplayName(
            journalEntry.getParentComponent(), action), journalEntry.getParentComponent().getId()
            .getResourceIdentifier(), journalEntry.isTopic() ? ObjectTypes.COLLECTION : ObjectTypes.COMMENT),
            new HashMap<String, Object>(0));

    }

    private static String getDisplayName(final SocialComponent journalEntry, final JournalEvent.JournalActions action) {
        if (journalEntry instanceof JournalEntryComment) {

            final String name =
                (action.getVerb().equals(Verbs.DELETE)) ? "" : ((JournalEntryComment) journalEntry).getSubject();
            if (StringUtils.isNotEmpty(name)) {
                return name;
            } else {
                return ((JournalEntryComment) journalEntry).isTopic() ? "a journal" : "a comment";
            }
        } else {
            if (journalEntry instanceof Journal) {
                return ((Journal) journalEntry).getTitle();
            } else {
                return null;
            }
        }
    }

    /**
     * List of available journal actions that can trigger a journal event.
     */
    public static enum JournalActions implements SocialEvent.SocialActions {
        CREATED, EDITED, DELETED, REPLY_CREATED, REPLY_EDITED, REPLY_DELETED;

        @Override
        public String getVerb() {
            switch (this) {
                case CREATED:
                    return Verbs.POST;
                case REPLY_CREATED:
                    return Verbs.ADD;
                case EDITED:
                case REPLY_EDITED:
                    return Verbs.UPDATE;
                case DELETED:
                case REPLY_DELETED:
                    return Verbs.DELETE;
                default:
                    throw new IllegalArgumentException();
            }
        }
    }
}
