/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.journal.client.api;

import java.util.Map;

import com.adobe.cq.social.scf.SocialCollectionComponent;

/**
 * Journal Sidebar component.
 */
public interface JournalSidebar extends SocialCollectionComponent {

    static final int MIN_TERM_FREQ = 0;
    static final int MIN_DOC_FREQ = 0;
    static final int MAX_RESULTS = -1;

    /** The resource type for sidebar component. */
    String RESOURCE_TYPE_SIDEBAR = "social/journal/components/hbs/sidebar";

    /** The name of authors view type. */
    String AUTHORS_VIEW_TYPE = "authors";

    /** The name of categories view type. */
    String CATEGORIES_VIEW_TYPE = "categories";

    /** The name of archives view type. */
    String ARCHIVES_VIEW_TYPE = "archives";

    /** The name of journal component path property. */
    String DEFAULT_JOURNAL_COMPONENT_PATH_PROPERTY = "journalComponentPath";

    String getViewType();

    Map<String, Map<String, String>> getItemsMap();

    Map<String, Integer> getCountMap();
}
