/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.journal.client.api;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentListProviderManager;
import com.adobe.cq.social.journal.client.impl.JournalSidebarImpl;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.core.AbstractSocialComponentFactory;

/**
 * @deprecated this class is not for public use in AEM 6.1. An alternative will be provided in a future featurepack
 */
@Deprecated
@Component
@Service(value = SocialComponentFactory.class)
public class JournalSidebarSocialComponentFactory extends AbstractSocialComponentFactory implements
    SocialComponentFactory {
    /** Logger for this class. */
    private static final Logger LOG = LoggerFactory.getLogger(JournalSocialComponentFactory.class);

    @Reference
    private CommentSocialComponentListProviderManager listProviderManager;

    @Override
    public String getSupportedResourceType() {
        return JournalSidebar.RESOURCE_TYPE_SIDEBAR;
    }

    @Override
    public SocialComponent getSocialComponent(final Resource resource) {
        return new JournalSidebarImpl(resource, getClientUtilities(resource.getResourceResolver()),
            getQueryRequestInfo(null), listProviderManager);
    }

    @Override
    public SocialComponent getSocialComponent(final Resource resource, final SlingHttpServletRequest request) {
        return new JournalSidebarImpl(resource, getClientUtilities(request), getQueryRequestInfo(request),
            listProviderManager);
    }

    @Override
    public SocialComponent getSocialComponent(final Resource resource, final ClientUtilities clientUtils,
        final QueryRequestInfo queryInfo) {
        return new JournalSidebarImpl(resource, clientUtils, queryInfo, listProviderManager);
    }
}
