/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.members.api;

import java.util.Map;

import javax.jcr.RepositoryException;

import org.apache.sling.api.resource.Resource;

import com.adobe.cq.social.scf.SocialAuthorizable;
import com.adobe.cq.social.user.api.UserProfile;
import com.adobe.granite.security.user.UserProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;

public interface CommunityMemberGroupProfile extends UserProfile {
    String RESOURCE_TYPE = "social/members/components/hbs/groupprofile";

    /**
     * Constant for the path to the group profile.
     */
    String PROFILE_PATH = "profile";

    /**
     * Returns the ID of the authorizable this user properties belong to.
     * @return the ID of the authorizable this user properties belong to.
     */
    String getAuthorizableID();

    /**
     * Calculate a display name from this <code>UserProfile</code> instance.
     * @return Implementation specific display name as stored in this user properties instance or some implementation
     *         specific default.
     * @throws RepositoryException If an error occurs.
     */
    String getDisplayName() throws RepositoryException;

    /**
     * Get the parent groups.
     */
    Map<String, String> getParentGroups();

    /**
     * Get the members of a group.
     * @return the members of a group
     */
    SocialAuthorizable[] getMembers();

    /**
     * @return number of members
     */
    Integer getNumberOfMembers();

    /**
     * Retrieve the resource at the specified path relative to this instance.
     * @param relativePath Relative path to the resource to be retrieved.
     * @return The resource at the specified relative path or <code>null</code> if the the path cannot be resolved to
     *         a resource.
     * @throws RepositoryException If an error occurs.
     */
    Resource getResource(String relativePath) throws RepositoryException;

    /**
     * Get properties from this <code>UserProfile</code> instance.
     * @return properties.
     * @throws RepositoryException If an error occurs.
     */
    Map<String, String> getProfileProperties();

    /**
     * Check if this <code>UserProfile</code> instance can be edited by current session.
     * @return true if current session can edit the user profile.
     */
    boolean isMayEdit();

    @JsonIgnore
    UserProperties getUserProperties();
}
